/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt52;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public class GuidedDecisionTable52
implements PortableObject {
    private static final long serialVersionUID = 510L;
    public static final int INTERNAL_ELEMENTS = 2;
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String TIMER_ATTR = "timer";
    public static final String CALENDARS_ATTR = "calendars";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String NEGATE_RULE_ATTR = "negate";
    private String tableName;
    private String parentName;
    private RowNumberCol52 rowNumberCol = new RowNumberCol52();
    private DescriptionCol52 descriptionCol = new DescriptionCol52();
    private List<MetadataCol52> metadataCols = new ArrayList<MetadataCol52>();
    private List<AttributeCol52> attributeCols = new ArrayList<AttributeCol52>();
    private List<CompositeColumn<? extends BaseColumn>> conditionPatterns = new ArrayList<CompositeColumn<? extends BaseColumn>>();
    private List<ActionCol52> actionCols = new ArrayList<ActionCol52>();
    private transient AnalysisCol52 analysisCol;
    private TableFormat tableFormat = TableFormat.EXTENDED_ENTRY;
    private List<List<DTCellValue52>> data = new ArrayList<List<DTCellValue52>>();
    private transient List<Analysis> analysisData;

    public GuidedDecisionTable52() {
        this.analysisCol = new AnalysisCol52();
        this.analysisCol.setHideColumn(true);
    }

    public List<ActionCol52> getActionCols() {
        return this.actionCols;
    }

    public List<AttributeCol52> getAttributeCols() {
        return this.attributeCols;
    }

    public List<Pattern52> getPatterns() {
        ArrayList<Pattern52> patterns = new ArrayList<Pattern52>();
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            if (!(cc instanceof Pattern52)) continue;
            patterns.add((Pattern52)cc);
        }
        return Collections.unmodifiableList(patterns);
    }

    public List<CompositeColumn<? extends BaseColumn>> getConditions() {
        return this.conditionPatterns;
    }

    public Pattern52 getConditionPattern(String boundName) {
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            Pattern52 p;
            if (!(cc instanceof Pattern52) || !(p = (Pattern52)cc).getBoundName().equals(boundName)) continue;
            return p;
        }
        return null;
    }

    public Pattern52 getPattern(ConditionCol52 col) {
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            Pattern52 p;
            if (!(cc instanceof Pattern52) || !(p = (Pattern52)cc).getChildColumns().contains(col)) continue;
            return p;
        }
        return new Pattern52();
    }

    public String getBoundFactType(String boundName) {
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            if (cc instanceof Pattern52) {
                Pattern52 p = (Pattern52)cc;
                if (!p.isBound() || !p.getBoundName().equals(boundName)) continue;
                return p.getFactType();
            }
            if (!(cc instanceof BRLConditionColumn)) continue;
            BRLConditionColumn brl = (BRLConditionColumn)cc;
            for (IPattern p : brl.getDefinition()) {
                FactPattern fp;
                if (!(p instanceof FactPattern) || !(fp = (FactPattern)p).isBound() || !fp.getBoundName().equals(boundName)) continue;
                return fp.getFactType();
            }
        }
        return new String();
    }

    public BRLColumn<?, ?> getBRLColumn(BRLVariableColumn col) {
        DTColumnConfig52 brl;
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            if (!(cc instanceof BRLConditionColumn) || !((BRLConditionColumn)(brl = (BRLConditionColumn)cc)).getChildColumns().contains(col)) continue;
            return brl;
        }
        for (ActionCol52 ac : this.actionCols) {
            if (!(ac instanceof BRLActionColumn) || !((BRLActionColumn)(brl = (BRLActionColumn)ac)).getChildColumns().contains(col)) continue;
            return brl;
        }
        throw new IllegalStateException("col is not a child of any of the defined BRLColumns.");
    }

    public BRLConditionColumn getBRLColumn(BRLConditionVariableColumn col) {
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            BRLConditionColumn brl;
            if (!(cc instanceof BRLConditionColumn) || !(brl = (BRLConditionColumn)cc).getChildColumns().contains(col)) continue;
            return brl;
        }
        throw new IllegalStateException("col is not a child of any of the defined BRLColumns.");
    }

    public BRLActionColumn getBRLColumn(BRLActionVariableColumn col) {
        for (ActionCol52 ac : this.actionCols) {
            BRLActionColumn brl;
            if (!(ac instanceof BRLActionColumn) || !(brl = (BRLActionColumn)ac).getChildColumns().contains(col)) continue;
            return brl;
        }
        throw new IllegalStateException("col is not a child of any of the defined BRLColumns.");
    }

    public long getConditionsCount() {
        long size = 0L;
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            size += (long)cc.getChildColumns().size();
        }
        return size;
    }

    public List<List<DTCellValue52>> getData() {
        return this.data;
    }

    public List<Analysis> getAnalysisData() {
        return this.analysisData;
    }

    public List<BaseColumn> getExpandedColumns() {
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>();
        columns.add(this.rowNumberCol);
        columns.add(this.descriptionCol);
        columns.addAll(this.metadataCols);
        columns.addAll(this.attributeCols);
        for (CompositeColumn<? extends BaseColumn> cc : this.conditionPatterns) {
            boolean explode;
            boolean bl = explode = !(cc instanceof LimitedEntryCol);
            if (explode) {
                for (BaseColumn baseColumn : cc.getChildColumns()) {
                    columns.add(baseColumn);
                }
                continue;
            }
            columns.add(cc);
        }
        for (ActionCol52 ac : this.actionCols) {
            if (ac instanceof BRLActionColumn) {
                if (ac instanceof LimitedEntryCol) {
                    columns.add(ac);
                    continue;
                }
                BRLActionColumn bac = (BRLActionColumn)ac;
                for (BRLActionVariableColumn bRLActionVariableColumn : bac.getChildColumns()) {
                    columns.add(bRLActionVariableColumn);
                }
                continue;
            }
            columns.add(ac);
        }
        columns.add(this.analysisCol);
        return columns;
    }

    public DescriptionCol52 getDescriptionCol() {
        if (this.descriptionCol == null) {
            this.descriptionCol = new DescriptionCol52();
        }
        return this.descriptionCol;
    }

    public List<MetadataCol52> getMetadataCols() {
        if (null == this.metadataCols) {
            this.metadataCols = new ArrayList<MetadataCol52>();
        }
        return this.metadataCols;
    }

    public String getParentName() {
        return this.parentName;
    }

    public RowNumberCol52 getRowNumberCol() {
        if (this.rowNumberCol == null) {
            this.rowNumberCol = new RowNumberCol52();
        }
        return this.rowNumberCol;
    }

    public void initAnalysisColumn() {
        this.analysisData = new ArrayList<Analysis>(this.data.size());
        for (int i = 0; i < this.data.size(); ++i) {
            this.analysisData.add(new Analysis());
        }
    }

    public AnalysisCol52 getAnalysisCol() {
        return this.analysisCol;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType(BaseColumn col, SuggestionCompletionEngine sce) {
        if (col instanceof RowNumberCol52) {
            return this.getType((RowNumberCol52)col, sce);
        }
        if (col instanceof AttributeCol52) {
            return this.getType((AttributeCol52)col, sce);
        }
        if (col instanceof BRLConditionVariableColumn) {
            return this.getType((BRLConditionVariableColumn)col, sce);
        }
        if (col instanceof ConditionCol52) {
            return this.getType((ConditionCol52)col, sce);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getType((ActionSetFieldCol52)col, sce);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getType((ActionInsertFactCol52)col, sce);
        }
        if (col instanceof BRLActionVariableColumn) {
            return this.getType((BRLActionVariableColumn)col, sce);
        }
        return "String";
    }

    private String getType(RowNumberCol52 col, SuggestionCompletionEngine sce) {
        return "Integer";
    }

    private String getType(AttributeCol52 col, SuggestionCompletionEngine sce) {
        String type = "String";
        String attrName = col.getAttribute();
        if (attrName.equals(SALIENCE_ATTR)) {
            type = "Integer";
        } else if (attrName.equals(ENABLED_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(NO_LOOP_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(DURATION_ATTR)) {
            type = "Long";
        } else if (attrName.equals(TIMER_ATTR)) {
            type = "String";
        } else if (attrName.equals(CALENDARS_ATTR)) {
            type = "String";
        } else if (attrName.equals(AUTO_FOCUS_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(LOCK_ON_ACTIVE_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(DATE_EFFECTIVE_ATTR)) {
            type = "Date";
        } else if (attrName.equals(DATE_EXPIRES_ATTR)) {
            type = "Date";
        } else if (attrName.equals(DIALECT_ATTR)) {
            type = "String";
        }
        return type;
    }

    private String getType(ConditionCol52 col, SuggestionCompletionEngine sce) {
        Pattern52 pattern = this.getPattern(col);
        return this.getType(pattern, col, sce);
    }

    private String getType(Pattern52 pattern, ConditionCol52 col, SuggestionCompletionEngine sce) {
        if (this.hasValueList(col)) {
            return "String";
        }
        if (SuggestionCompletionEngine.operatorRequiresList(col.getOperator())) {
            return "String";
        }
        if (col.getConstraintValueType() == 1 && (col.getOperator() == null || "".equals(col.getOperator()))) {
            return "String";
        }
        if (col.getConstraintValueType() == 5) {
            return "String";
        }
        if (col.getConstraintValueType() == 3) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getType(BRLConditionVariableColumn col, SuggestionCompletionEngine sce) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getType(ActionSetFieldCol52 col, SuggestionCompletionEngine sce) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = this.getBoundFactType(col.getBoundName());
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getType(Pattern52 pattern, ActionSetFieldCol52 col, SuggestionCompletionEngine sce) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = pattern.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getType(ActionInsertFactCol52 col, SuggestionCompletionEngine sce) {
        if (this.hasValueList(col)) {
            return "String";
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getType(BRLActionVariableColumn col, SuggestionCompletionEngine sce) {
        if (col.getFactType() == null && col.getFactField() == null) {
            return col.getFieldType();
        }
        String factType = col.getFactType();
        String fieldName = col.getFactField();
        return this.getTypeFromSCE(factType, fieldName, sce);
    }

    private String getTypeFromSCE(String factType, String fieldName, SuggestionCompletionEngine sce) {
        if (sce.hasEnums(factType, fieldName)) {
            return "String";
        }
        String type = sce.getFieldType(factType, fieldName);
        return type;
    }

    public DTDataTypes52 getTypeSafeType(BaseColumn column, SuggestionCompletionEngine sce) {
        String type = this.getType(column, sce);
        return this.convertToTypeSafeType(type);
    }

    public DTDataTypes52 getTypeSafeType(Pattern52 pattern, ConditionCol52 column, SuggestionCompletionEngine sce) {
        String type = this.getType(pattern, column, sce);
        return this.convertToTypeSafeType(type);
    }

    public DTDataTypes52 getTypeSafeType(Pattern52 pattern, ActionSetFieldCol52 column, SuggestionCompletionEngine sce) {
        String type = this.getType(pattern, column, sce);
        return this.convertToTypeSafeType(type);
    }

    private DTDataTypes52 convertToTypeSafeType(String type) {
        if (type.equals("Numeric")) {
            return DTDataTypes52.NUMERIC;
        }
        if (type.equals("BigDecimal")) {
            return DTDataTypes52.NUMERIC_BIGDECIMAL;
        }
        if (type.equals("BigInteger")) {
            return DTDataTypes52.NUMERIC_BIGINTEGER;
        }
        if (type.equals("Byte")) {
            return DTDataTypes52.NUMERIC_BYTE;
        }
        if (type.equals("Double")) {
            return DTDataTypes52.NUMERIC_DOUBLE;
        }
        if (type.equals("Float")) {
            return DTDataTypes52.NUMERIC_FLOAT;
        }
        if (type.equals("Integer")) {
            return DTDataTypes52.NUMERIC_INTEGER;
        }
        if (type.equals("Long")) {
            return DTDataTypes52.NUMERIC_LONG;
        }
        if (type.equals("Short")) {
            return DTDataTypes52.NUMERIC_SHORT;
        }
        if (type.equals("Boolean")) {
            return DTDataTypes52.BOOLEAN;
        }
        if (type.equals("Date")) {
            return DTDataTypes52.DATE;
        }
        return DTDataTypes52.STRING;
    }

    public String[] getValueList(BaseColumn col) {
        if (col instanceof AttributeCol52) {
            return this.getValueList((AttributeCol52)col);
        }
        if (col instanceof ConditionCol52) {
            return this.getValueList((ConditionCol52)col);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getValueList((ActionSetFieldCol52)col);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getValueList((ActionInsertFactCol52)col);
        }
        return new String[0];
    }

    private String[] getValueList(AttributeCol52 col) {
        if (NO_LOOP_ATTR.equals(col.getAttribute()) || ENABLED_ATTR.equals(col.getAttribute())) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    private String[] getValueList(ConditionCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    private String[] getValueList(ActionSetFieldCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    private String[] getValueList(ActionInsertFactCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        return new String[0];
    }

    public boolean hasValueList(AttributeCol52 col) {
        return NO_LOOP_ATTR.equals(col.getAttribute()) || ENABLED_ATTR.equals(col.getAttribute());
    }

    public boolean hasValueList(ConditionCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionSetFieldCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean hasValueList(ActionInsertFactCol52 col) {
        return col.getValueList() != null && !"".equals(col.getValueList());
    }

    public boolean isConstraintValid(DTColumnConfig52 col) {
        if (col instanceof RowNumberCol52) {
            return true;
        }
        if (col instanceof DescriptionCol52) {
            return true;
        }
        if (col instanceof MetadataCol52) {
            return true;
        }
        if (col instanceof AttributeCol52) {
            return true;
        }
        if (col instanceof ConditionCol52) {
            ConditionCol52 c = (ConditionCol52)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol52;
    }

    public void setData(List<List<DTCellValue52>> data) {
        this.data = data;
    }

    public void setRowNumberCol(RowNumberCol52 rowNumberCol) {
        this.rowNumberCol = rowNumberCol;
    }

    public void setDescriptionCol(DescriptionCol52 descriptionCol) {
        this.descriptionCol = descriptionCol;
    }

    public void setMetadataCols(List<MetadataCol52> metadataCols) {
        this.metadataCols = metadataCols;
    }

    public void setAttributeCols(List<AttributeCol52> attributeCols) {
        this.attributeCols = attributeCols;
    }

    public void setConditionPatterns(List<CompositeColumn<? extends BaseColumn>> conditionPatterns) {
        this.conditionPatterns = conditionPatterns;
    }

    public void setActionCols(List<ActionCol52> actionCols) {
        this.actionCols = actionCols;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableFormat getTableFormat() {
        return this.tableFormat == null ? TableFormat.EXTENDED_ENTRY : this.tableFormat;
    }

    public void setTableFormat(TableFormat tableFormat) {
        this.tableFormat = tableFormat;
    }

    public boolean hasDSLSentences() {
        DTColumnConfig52 brlColumn;
        for (CompositeColumn<? extends BaseColumn> compositeColumn : this.conditionPatterns) {
            if (!(compositeColumn instanceof BRLConditionColumn)) continue;
            brlColumn = (BRLConditionColumn)compositeColumn;
            for (IPattern pattern : ((BRLConditionColumn)brlColumn).getDefinition()) {
                if (!(pattern instanceof DSLSentence)) continue;
                return true;
            }
        }
        for (ActionCol52 actionCol52 : this.actionCols) {
            if (!(actionCol52 instanceof BRLActionColumn)) continue;
            brlColumn = (BRLActionColumn)actionCol52;
            for (IAction action : ((BRLActionColumn)brlColumn).getDefinition()) {
                if (!(action instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum TableFormat {
        EXTENDED_ENTRY,
        LIMITED_ENTRY;

    }
}

